%------------------------------------------------------------------------------
% File     : PUZ149^13 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Puzzles
% Problem  : The bungling chemist
% Version  : [BP13] axioms.
% English  : Assume that a chemical compound c is made by pouring the elements
%            a and b into the same beaker. The two elements a and b are not
%            acid. It is possible that after making the compound c it results
%            in an acid. Then it is possible that pouring element a results
%            not in an acid, and pouring a and b in the beaker results in an
%            acid.

% Refs     : [Bal98] Baldoni (1998), Normal Multimodal Logics: Automatic De
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : MML006+1 [QMLTP]

% Status   : Theorem 
% Rating   : 0.22 v9.1.0, 0.25 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0
% Syntax   : Number of formulae    :   31 (   8 unt;  16 typ;   8 def)
%            Number of atoms       :   65 (   8 equ;   0 cnn)
%            Maximal formula atoms :    9 (   4 avg)
%            Number of connectives :   82 (   1   ~;   1   |;   2   &;  75   @)
%                                         (   1 <=>;   2  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    7 (   3 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   49 (  49   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   15 (  14 usr;   4 con; 0-3 aty)
%            Number of variables   :   23 (  21   ^;   1   !;   1   ?;  23   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $cumulative,
%            $modalities == $modal_system_K].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mindex,type,
    mindex: $tType ).

thf(mrel_type,type,
    mrel: mindex > mworld > mworld > $o ).

thf('#pour_b_type',type,
    '#pour_b': mindex ).

thf('#make_c_type',type,
    '#make_c': mindex ).

thf('#pour_a_type',type,
    '#pour_a': mindex ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: mindex > ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ R @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: mindex > ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ R @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(acid_decl,type,
    acid: mworld > $o ).

thf(pour_ab_make_axiom_1,axiom,
    mlocal @ ( mimplies @ ( mbox @ '#pour_a' @ ( mbox @ '#pour_b' @ acid ) ) @ ( mbox @ '#make_c' @ acid ) ) ).

thf(pour_ab_make_axiom_2,axiom,
    mlocal @ ( mimplies @ ( mbox @ '#pour_a' @ ( mbox @ '#pour_b' @ ( mnot @ acid ) ) ) @ ( mbox @ '#make_c' @ ( mnot @ acid ) ) ) ).

thf(pour_ba_make_axiom_1,axiom,
    mlocal @ ( mimplies @ ( mbox @ '#pour_b' @ ( mbox @ '#pour_a' @ acid ) ) @ ( mbox @ '#make_c' @ acid ) ) ).

thf(pour_ba_make_axiom_2,axiom,
    mlocal @ ( mimplies @ ( mbox @ '#pour_b' @ ( mbox @ '#pour_a' @ ( mnot @ acid ) ) ) @ ( mbox @ '#make_c' @ ( mnot @ acid ) ) ) ).

thf(pour_a_acid,axiom,
    mlocal @ ( mbox @ '#pour_a' @ ( mnot @ acid ) ) ).

thf(make_c_acid,axiom,
    mlocal @ ( mdia @ '#make_c' @ acid ) ).

thf(conj,conjecture,
    mlocal @ ( mand @ ( mdia @ '#pour_a' @ ( mnot @ acid ) ) @ ( mdia @ '#pour_a' @ ( mdia @ '#pour_b' @ acid ) ) ) ).

%------------------------------------------------------------------------------
